/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_VARIABLE_API_
#define SPICE3_VARIABLE_API_

#include "rlTypes.h"

RL_C_API rlResult rlVariableBooleanCreate(rlHandle handle, const char* name, bool initialValue);
RL_C_API rlResult rlVariableBooleanDelete(rlHandle handle, const char* name, bool fromDisk);
RL_C_API rlResult rlVariableBooleanExists(rlHandle handle, const char* name, bool* exists);
RL_C_API rlResult rlVariableBooleanLoad(rlHandle handle, const char* name);
RL_C_API rlResult rlVariableBooleanStore(rlHandle handle, const char* name);

RL_C_API rlResult rlVariableBooleanGetValue(rlHandle handle, const char* name, bool* value);
RL_C_API rlResult rlVariableBooleanSetValue(rlHandle handle, const char* name, bool value);
RL_C_API rlResult rlVariableBooleanToggleValue(rlHandle handle, const char* name);

RL_C_API rlResult rlVariableIntegerCreate(rlHandle handle, const char* name, int32_t initialValue);
RL_C_API rlResult rlVariableIntegerDelete(rlHandle handle, const char* name, bool fromDisk);
RL_C_API rlResult rlVariableIntegerExists(rlHandle handle, const char* name, bool* exists);
RL_C_API rlResult rlVariableIntegerLoad(rlHandle handle, const char* name);
RL_C_API rlResult rlVariableIntegerStore(rlHandle handle, const char* name);

RL_C_API rlResult rlVariableIntegerGetValue(rlHandle handle, const char* name, int32_t* value);
RL_C_API rlResult rlVariableIntegerSetValue(rlHandle handle, const char* name, int32_t value);
RL_C_API rlResult rlVariableIntegerIncrementValue(rlHandle handle, const char* name);
RL_C_API rlResult rlVariableIntegerDecrementValue(rlHandle handle, const char* name);

RL_C_API rlResult rlVariableSignalCreate(rlHandle handle, const char* name, bool initialValue, bool autoReset);
RL_C_API rlResult rlVariableSignalDelete(rlHandle handle, const char* name, bool fromDisk);
RL_C_API rlResult rlVariableSignalExists(rlHandle handle, const char* name, bool* exists);
RL_C_API rlResult rlVariableSignalLoad(rlHandle handle, const char* name);
RL_C_API rlResult rlVariableSignalStore(rlHandle handle, const char* name);

RL_C_API rlResult rlVariableSignalSet(rlHandle handle, const char* name);
RL_C_API rlResult rlVariableSignalReset(rlHandle handle, const char* name);
RL_C_API rlResult rlVariableSignalIsAutoResetEnabled(rlHandle handle, const char* name, bool* enabled);
RL_C_API rlResult rlVariableSignalIsSet(rlHandle handle, const char* name, bool* isSet);

RL_C_API rlResult rlVariableMarkCounterCreate(rlHandle handle, const char* name, int32_t initialValue);
RL_C_API rlResult rlVariableMarkCounterDelete(rlHandle handle, const char* name, bool fromDisk);
RL_C_API rlResult rlVariableMarkCounterExists(rlHandle handle, const char* name, bool* exists);
RL_C_API rlResult rlVariableMarkCounterLoad(rlHandle handle, const char* name);
RL_C_API rlResult rlVariableMarkCounterStore(rlHandle handle, const char* name);

RL_C_API rlResult rlVariableMarkCounterGetValue(rlHandle handle, const char* name, int32_t* value);
RL_C_API rlResult rlVariableMarkCounterSetValue(rlHandle handle, const char* name, int32_t value);
RL_C_API rlResult rlVariableMarkCounterGetAndResetValue(rlHandle handle, const char* name, int32_t* value);

RL_C_API rlResult rlVariableMarkCounterGetMarkTimeFormat(rlHandle handle, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlVariableMarkCounterSetMarkTimeFormat(rlHandle handle, const char* format);

#endif // SPICE3_VARIABLE_API_
